package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.Calendar;
import java.util.Date;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.service.ActivityService;
import gov.va.med.mhv.usermgmt.service.AuthenticateService;
import gov.va.med.mhv.usermgmt.service.MviTreatmentFacilityUpdator;
import gov.va.med.mhv.usermgmt.service.PatientService;
import gov.va.med.mhv.usermgmt.service.UserProfileService;


public class AuthenticateServiceImpl implements AuthenticateService {

	
	@Autowired 
	private ActivityService activityService;
	
	@Autowired 
	private UserProfileService userProfileService;
	
	@Autowired
	@Qualifier("treatmentFacilityUpdator")
	private MviTreatmentFacilityUpdator mviIntegrationService;
	
	@Autowired
	private PatientService patientService;
	
	protected static Logger log = LogManager.getLogger(AuthenticateServiceImpl.class);
	

	public ResponseUtil<UserProfileDTO> authenticateUser(String userName, String password) {
		ResponseUtil<UserProfileDTO> response = new ResponseUtil<UserProfileDTO>();
		 
		UserProfileDTO user = userProfileService.getUserProfileByUserName(userName);
		if (null == user){
			response.setFailure(true);
			response.setFailureMessage("Could not Authenticate User");
		 } else if (!authenticate(userName, password)){
			response.setFailure(true);
			response.setFailureMessage("Could not Authenticate User");
		 }  
		else{	
			processFacilitiesUpdate(user);
			processLastLogin(user);
			activityService.createLoginActivity(userName, user.getId(),Boolean.TRUE);
			response.setSuccess(true);
			response.setPojoObject(user);
	 	}
		
		return response;
	}
	
	public ResponseUtil<UserProfileDTO> postLoginUserUpdate(Long userProfileId) {
		ResponseUtil<UserProfileDTO> response = new ResponseUtil<UserProfileDTO>();
		 
		UserProfileDTO user = (UserProfileDTO)userProfileService.getUserProfileByID(userProfileId).getPojoObject();
		
		if (null == user){
			response.setFailure(true);
			response.setFailureMessage("Could not Authenticate User");
		 } /*else if (!authenticate(userName, password)){
			response.setFailure(true);
			response.setFailureMessage("Could not Authenticate User");
		 } */ 
		else{	
			activityService.createLoginActivity(user.getUserName(), user.getId(),Boolean.TRUE);
			processFacilitiesUpdate(user);
			processLastLogin(user);
			response.setSuccess(true);
			response.setPojoObject(user);
	 	}
		
		return response;
	}
	
	private void processLastLogin(UserProfileDTO user) {
		//JAZZ # 111941 - Remote ID Proofing - Last Login
		if(user.getCurrentLogin()!=null) {
			user.setLastLogin(user.getCurrentLogin());
		}
		//Jazz136316 Logout box date time change
		user.setCurrentLogin(new Date());
		userProfileService.saveUserProfile(user, new ResponseUtil(), false);
	}
	
	//JAZZ # 128616 - Process Facilities Update
    private void processFacilitiesUpdate(UserProfileDTO user) {
		boolean sameDay = false;
		
		ResponseUtil resp = patientService.getPatientByUserProfileId(user.getId());
		
		PatientDTO patient = (PatientDTO)resp.getPojoObject();
		
		//02/1/2016: We need to check to see if patientDTO exists before doing the facility update.
		if(patient != null) {
			if(patient.getLastFacilitiesUpdateDateTime() != null) {
				Calendar now = Calendar.getInstance();
				//now.setTime(now.getTime() - 1000*60*60*24);
				Calendar lastFacilitiesUpdate = Calendar.getInstance();
				lastFacilitiesUpdate.setTime(patient.getLastFacilitiesUpdateDateTime());
	
				sameDay = now.get(Calendar.YEAR) == lastFacilitiesUpdate.get(Calendar.YEAR) &&
					now.get(Calendar.DAY_OF_YEAR) == lastFacilitiesUpdate.get(Calendar.DAY_OF_YEAR);
			}
			if(!sameDay) {
				try {
					//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
					mviIntegrationService.updateTreatmentFacilitiesForExistingPatients(patient);
				} catch (MHVException e) {
					log.error("Error updating facilities for patient.", e);
				}
			}
		}
    }
	
	
	
	/**
	 * @TODO follow up with core dev to find out where this happens.
	 * @param userName
	 * @param password
	 * @return
	 */
	private boolean authenticate(String userName, String password){
		//@TODO -- mhv seems to hava a .jar that does this!! RESEARCH
		/**LEGACY CODE -- Asked Lanny where this is, need to follow up.
		 * Authentication.java -->UserServiceDelegate --> UserServiceImpl.java calls:

		com.bea.p13n.security.Authentication.authenticate(String userName, String Pasword);

		I couldn't find this .jar file in myprojects->.... Repository maven jars.

		We will need to research to find out where the back end code to do the actual authetication happens.

		I didn't see a password in the user profile table -- so I am not sure where this is stored. 
		
		 */
		
		
		return true;
	}
	
	 
	 
	
	
	
	
	
	
	

}
